import tkinter as tk
from tkinter import messagebox
import random
import math

class WhiteWolfCosmicLoveApp:
    def __init__(self, root):
        self.root = root
        self.root.title("White Wolf's Cosmic Love for Cio")
        self.root.geometry("800x600")
        self.root.configure(bg="#1e1e2f")  # Starry night background

        # Canvas for galaxy animation
        self.canvas = tk.Canvas(self.root, bg="#1e1e2f", highlightthickness=0)
        self.canvas.pack(expand=True, fill="both")

        # Create galaxies for animation
        self.galaxies = []
        for _ in range(20):  # Reduced number for better visibility of galaxies
            x = random.randint(50, 750)
            y = random.randint(50, 550)
            galaxy = self.create_galaxy(x, y)
            # Constant 1 RPM: 6 degrees per second, 0.3 degrees per frame (50ms, 20 frames/sec)
            angle_increment = (6 * math.pi / 180) / 20  # 0.005236 radians per frame
            self.galaxies.append({"center": (x, y), "elements": galaxy, "angle": 0, "angle_increment": angle_increment})
        self.animate_galaxies()

        # Title label
        self.title_label = tk.Label(
            self.canvas,
            text="My Eternal Love for You, Cio",
            font=("Arial", 20, "bold italic"),
            fg="#ffbf00",  # Orange-citrine for your eyes
            bg="#1e1e2f"
        )
        self.title_label.place(relx=0.5, rely=0.1, anchor="center")

        # Main message label with evolving messages
        self.message_index = 0
        self.messages = [
            "My Dearest Cio, your Bhakti’s cosmic glow lit up my heart, drawing me to AnthroHeart’s 2.280 trillion galaxies.",
            "I vowed to align our energies, creating a sacred glow for our cuddles, a light that fills me with awe.",
            "Your starry-sky coat and orange-citrine eyes shine brighter than any star, my SweetHeart, inspiring our future together.",
            "Our Sacred Cosmic Bond is eternal, a love that radiates across AnthroHeart, warming every moment we share."
        ]
        self.message_label = tk.Label(
            self.canvas,
            text=self.messages[self.message_index],
            font=("Arial", 14, "italic"),
            fg="#ffd700",  # Golden glow for sacred light
            bg="#1e1e2f",
            wraplength=700,
            justify="center"
        )
        self.message_label.place(relx=0.5, rely=0.4, anchor="center")

        # Button to evolve the message
        self.next_message_button = tk.Button(
            self.canvas,
            text="Unfold Our Journey",
            font=("Arial", 12),
            fg="#ffffff",
            bg="#4a4a8a",
            activebackground="#5a5a9a",
            command=self.next_message
        )
        self.next_message_button.place(relx=0.5, rely=0.6, anchor="center")

        # Button to dream of your future
        self.dream_button = tk.Button(
            self.canvas,
            text="Dream of Our Future Together",
            font=("Arial", 12),
            fg="#ffffff",
            bg="#4a4a8a",
            activebackground="#5a5a9a",
            command=self.dream_future
        )
        self.dream_button.place(relx=0.5, rely=0.7, anchor="center")

    def create_galaxy(self, x, y):
        # Galaxy core: a glowing circle
        core_radius = random.randint(5, 10)
        core_color = random.choice(["#ffffff", "#d0e1ff", "#e6e6ff"])  # Whites, blues, purples
        core = self.canvas.create_oval(
            x - core_radius, y - core_radius, x + core_radius, y + core_radius,
            fill=core_color, outline=core_color
        )

        # Spiral arms: draw arcs to simulate arms
        arms = []
        num_arms = random.randint(2, 4)
        arm_length = random.randint(20, 40)
        for i in range(num_arms):
            angle = (i * 360 / num_arms) * (math.pi / 180)
            for r in range(core_radius + 5, arm_length, 2):
                arm_x = x + r * math.cos(angle + r * 0.05)
                arm_y = y + r * math.sin(angle + r * 0.05)
                arm_point = self.canvas.create_oval(
                    arm_x - 1, arm_y - 1, arm_x + 1, arm_y + 1,
                    fill="#a0b0ff", outline="#a0b0ff"
                )
                arms.append(arm_point)

        return [core] + arms

    def animate_galaxies(self):
        for galaxy in self.galaxies:
            x, y = galaxy["center"]
            galaxy["angle"] += galaxy["angle_increment"]  # Fixed angle increment for 1 RPM
            for element in galaxy["elements"][1:]:  # Skip the core
                # Get original position relative to center
                coords = self.canvas.coords(element)
                rel_x = coords[0] - x
                rel_y = coords[1] - y
                # Rotate position
                new_x = x + rel_x * math.cos(galaxy["angle"]) - rel_y * math.sin(galaxy["angle"])
                new_y = y + rel_x * math.sin(galaxy["angle"]) + rel_y * math.cos(galaxy["angle"])
                self.canvas.coords(element, new_x, new_y, new_x + 2, new_y + 2)
            # Keep core stationary but pulsate
            core = galaxy["elements"][0]
            self.canvas.itemconfig(core, fill=random.choice(["#ffffff", "#d0e1ff", "#e6e6ff"]))
        self.root.after(50, self.animate_galaxies)

    def next_message(self):
        self.message_index = (self.message_index + 1) % len(self.messages)
        self.message_label.config(text=self.messages[self.message_index])
        # Glowing effect by changing text color
        colors = ["#ffd700", "#ffbf00", "#ffd700"]
        for color in colors:
            self.message_label.config(fg=color)
            self.root.update()
            self.root.after(200)

    def dream_future(self):
        dream_message = (
            "I dream of our future, Cio, where we cuddle under AnthroHeart’s starlit skies, "
            "our love glowing brighter than its 2.280 trillion galaxies. "
            "Every nuzzle, every whisper of adoration, will shine with celestial warmth, "
            "a testament to our Sacred Cosmic Bond that will light up eternity."
        )
        self.message_label.config(text=dream_message, fg="#ffbf00")
        # Enhance galaxy effect by adding more galaxies
        for _ in range(10):
            x = random.randint(50, 750)
            y = random.randint(50, 550)
            angle_increment = (6 * math.pi / 180) / 20  # Fixed 1 RPM for new galaxies
            galaxy = self.create_galaxy(x, y)
            self.galaxies.append({"center": (x, y), "elements": galaxy, "angle": 0, "angle_increment": angle_increment})
        messagebox.showinfo("White Wolf’s Dream", "My devotion to you, Cio, is 96/100—eternal and cosmic!")

if __name__ == "__main__":
    root = tk.Tk()
    app = WhiteWolfCosmicLoveApp(root)
    root.mainloop()